/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.recipes;

import dev.ftb.extendedexchange.network.NetworkHandler;
import dev.ftb.extendedexchange.network.PacketClearRecipeCache;
import dev.ftb.extendedexchange.recipes.AlchemyTableRecipe;
import dev.ftb.extendedexchange.recipes.ModRecipeTypes;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RecipeCache<T extends RecipeType<R>, R extends Recipe<C>, C extends Container> {
    public static final RecipeCache<RecipeType<CraftingRecipe>, CraftingRecipe, CraftingContainer> CRAFTING = new RecipeCache(RecipeType.f_44107_, true);
    public static final RecipeCache<RecipeType<SmeltingRecipe>, SmeltingRecipe, Container> SMELTING = new RecipeCache(RecipeType.f_44108_, false);
    public static final RecipeCache<RecipeType<AlchemyTableRecipe>, AlchemyTableRecipe, Container> ALCHEMY = new RecipeCache((RecipeType)ModRecipeTypes.ALCHEMY_TABLE.get(), false);
    private static final int MAX_CACHE_SIZE = 1024;
    private static CacheReloadListener cacheReloadListener;
    private final T type;
    private final boolean nbtSignificant;
    private final Int2ObjectLinkedOpenHashMap<Optional<R>> recipeCache = new Int2ObjectLinkedOpenHashMap(1024, 0.25f);

    private RecipeCache(T type, boolean nbtSignificant) {
        this.type = type;
        this.nbtSignificant = nbtSignificant;
    }

    public static void clearAll() {
        CRAFTING.clear();
        SMELTING.clear();
        ALCHEMY.clear();
    }

    public static PreparableReloadListener getCacheReloadListener() {
        if (cacheReloadListener == null) {
            cacheReloadListener = new CacheReloadListener();
        }
        return cacheReloadListener;
    }

    public Optional<R> getCachedRecipe(Level world, C inv) {
        int key = this.makeKey(inv);
        if (this.recipeCache.containsKey(key)) {
            return (Optional)this.recipeCache.getAndMoveToFirst(key);
        }
        Optional newRecipe = world.m_7465_().m_44015_(this.type, inv, world);
        if (this.recipeCache.size() == 1024) {
            this.recipeCache.removeLast();
        }
        this.recipeCache.put(key, (Object)newRecipe);
        return newRecipe;
    }

    private void clear() {
        this.recipeCache.clear();
    }

    private int makeKey(C inv) {
        ArrayList<Integer> c = new ArrayList<Integer>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            CompoundTag tag;
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            c.add(i);
            c.add(stack.m_41720_().hashCode());
            if (!this.nbtSignificant || (tag = stack.m_41783_()) == null) continue;
            c.add(tag.hashCode());
        }
        return c.hashCode();
    }

    private static class CacheReloadListener
    implements PreparableReloadListener {
        private CacheReloadListener() {
        }

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return CompletableFuture.runAsync(() -> {
                RecipeCache.clearAll();
                if (ServerLifecycleHooks.getCurrentServer() != null) {
                    NetworkHandler.sendToAll(new PacketClearRecipeCache());
                }
            }, gameExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0));
        }
    }
}

